<?php
/* --------------------------------------------------------------
   ParcelServiceService.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService;

use Gambio\Admin\ParcelService\Interfaces\ParcelService;
use Gambio\Admin\ParcelService\Interfaces\ParcelServiceId;
use Gambio\Admin\ParcelService\Interfaces\ParcelServiceIds;
use Gambio\Admin\ParcelService\Interfaces\ParcelServices;
use Gambio\Admin\ParcelService\Interfaces\ParcelServiceSqlCriteria;
use Gambio\Admin\ParcelService\Interfaces\ParcelServiceSqlPagination;
use Gambio\Admin\ParcelService\Repository\ParcelServiceRepository;

/**
 * Class ParcelServiceService
 *
 * @package Gambio\Admin\ParcelService
 */
class ParcelServiceService implements Interfaces\ParcelServiceService
{
    /**
     * @var ParcelServiceRepository
     */
    private $repository;
    
    
    public function __construct(ParcelServiceRepository $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getAllParcelServices(
        ParcelServiceSqlCriteria $criteria,
        ParcelServiceSqlPagination $pagination
    ): ParcelServices {
        return $this->repository->getAll($criteria, $pagination);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getTotalCountOfParcelServices(ParcelServiceSqlCriteria $criteria): int
    {
        return $this->repository->getTotalCount($criteria);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getParcelServiceById(ParcelServiceId $id): ParcelService
    {
        return $this->repository->getById($id);
    }
    
    
    /**
     * @inheritDoc
     */
    public function storeParcelService(ParcelService $parcelService): ParcelServiceId
    {
        return $this->repository->store($parcelService);
    }
    
    
    /**
     * @inheritDoc
     */
    public function storeParcelServices(ParcelServices $parcelServices): ParcelServiceIds
    {
        return $this->repository->storeMultiple($parcelServices);
    }
    
    
    /**
     * @inheritDoc
     */
    public function deleteParcelService(ParcelServiceId $id): void
    {
        $this->repository->delete($id);
    }
    
    
    /**
     * @inheritDoc
     */
    public function deleteParcelServices(ParcelServiceIds $ids): void
    {
        $this->repository->deleteMultiple($ids);
    }
}